% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr-verbs.r
\name{dplyr-verbs}
\alias{dplyr-verbs}
\alias{pull_factor}
\alias{pull_rows}
\alias{pull_cols}
\alias{rename_rows}
\alias{rename_cols}
\alias{select_rows}
\alias{select_cols}
\alias{mutate_rows}
\alias{mutate_cols}
\alias{transmute_rows}
\alias{transmute_cols}
\alias{cbind_rows}
\alias{cbind_cols}
\alias{left_join_rows}
\alias{left_join_cols}
\title{\strong{dplyr} verbs for tbl_ord factors}
\usage{
pull_factor(.data, var = -1, .matrix)

pull_rows(.data, var = -1)

pull_cols(.data, var = -1)

rename_rows(.data, ...)

rename_cols(.data, ...)

select_rows(.data, ...)

select_cols(.data, ...)

mutate_rows(.data, ...)

mutate_cols(.data, ...)

transmute_rows(.data, ...)

transmute_cols(.data, ...)

cbind_rows(.data, ..., elements = "all")

cbind_cols(.data, ..., elements = "all")

left_join_rows(.data, ...)

left_join_cols(.data, ...)
}
\arguments{
\item{.data}{An object of class '\link{tbl_ord}'.}

\item{var}{A variable specified as in \code{\link[dplyr:pull]{dplyr::pull()}}.}

\item{.matrix}{A character string partially matched (lowercase) to several
indicators for one or both matrices in a matrix decomposition used for
ordination. The standard values are \code{"rows"}, \code{"cols"}, and \code{"dims"} (for
both).}

\item{...}{Comma-separated unquoted expressions as in, e.g.,
\code{\link[dplyr:select]{dplyr::select()}}.}

\item{elements}{Character vector; which elements of each factor for which to
render graphical elements. One of \code{"all"} (the default), \code{"active"}, or any
supplementary element type defined by the specific class methods (e.g.
\code{"score"} for 'factanal', 'lda_ord', and 'cancord_ord' and \code{"intraset"} and
\code{"interset"} for 'cancor_ord').}
}
\value{
A tbl_ord; the wrapped model is unchanged.
}
\description{
These functions adapt \link[dplyr:dplyr-package]{dplyr} verbs to the factors
of a \link{tbl_ord}.

The raw verbs are not defined for tbl_ords; instead, each verb
has two analogues, corresponding to the two matrix factors. They each rely
on a common workhorse function, which takes the composition of the
\strong{dplyr} verb with \verb{annotation_*}, applied to the factor, removes any
variables corresponding to coordinates or already annotated, and only then
assigns it as the new \code{"*_annotation"} attribute of \code{.data} (see
\link{annotation}). Note that these functions are not generics and so cannot be
extended to other classes.
}
\examples{
# illustrative ordination: LDA of iris data
(iris_lda <- ordinate(iris, cols = 1:4, lda_ord, grouping = iris$Species))

# extract a coordinate or annotation
head(pull_rows(iris_lda, Species))
pull_cols(iris_lda, LD2)

# rename an annotation
rename_cols(iris_lda, species = name)

# select annotations
select_rows(iris_lda, species = name, .element)

# create, modify, and delete annotations
mutate_cols(iris_lda, vec.length = sqrt(LD1^2 + LD2^2))
transmute_cols(iris_lda, vec.length = sqrt(LD1^2 + LD2^2))

# bind data frames of annotations
iris_medians <-
  stats::aggregate(iris[, 1:4], median, by = iris[, 5, drop = FALSE])
iris_lda \%>\%
  # retain '.element' in order to match by `elements`
  select_rows(.element) \%>\%
  cbind_rows(iris_medians, elements = "active")
}
