% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.ordfor.R
\name{plot.ordfor}
\alias{plot.ordfor}
\title{Visualization of optimized partition}
\usage{
\method{plot}{ordfor}(x, useggplot = TRUE, ...)
}
\arguments{
\item{x}{object of class \code{ordfor}. See function \code{\link{ordfor}}.}

\item{useggplot}{logical. Should R package \code{ggplot2} be used to produce a more neatly looking plot?}

\item{...}{other parameters to be passed through to plotting functions if \code{useggplot=FALSE}.}
}
\value{
If \code{useggplot = TRUE} (default) a \code{ggplot} x is returned where the ggplot2 plot is also shown on the current device. See \code{?ggplot} for saving ggplot2 plots.
If \code{useggplot = FALSE} \code{NULL} is returned.
}
\description{
Visualization of the optimized partition of [0,1] interpretable as the 
relative widths of the classes of the ordinal target variable.
}
\examples{
data(hearth)

set.seed(123)
hearthsubset <- hearth[sort(sample(1:nrow(hearth), size=floor(nrow(hearth)*(1/2)))),]
ordforres <- ordfor(depvar="Class", data=hearthsubset, ndiv=80, nbest=5)
# NOTE: ndiv=80 is not enough!! In practice, ndiv=1000 (default value) or a higher
# number should be used.

plot(ordforres)

plot(ordforres, useggplot=FALSE)

}

