% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/order_gpareto.R
\name{order_gpareto}
\alias{order_gpareto}
\title{Random Sampling of k-th Order Statistics from a Generalized Pareto Distribution}
\usage{
order_gpareto(size, k, shape1, shape2, scale, n, alpha = 0.05, ...)
}
\arguments{
\item{size}{numeric, represents the size of the sample.}

\item{k}{numeric, represents the Kth smallest value from a sample.}

\item{shape1}{numeric, represents a first shape parameter value. Must be strictly positive.}

\item{shape2}{numeric, represents a second shape parameter value. Must be strictly positive.}

\item{scale}{numeric, represents scale parameter values. Must be strictly positive.}

\item{n}{numeric, represents the size of the sample to compute the order statistic from.}

\item{alpha}{numeric, (1 - alpha) represents the confidence of an interval for the population median of the distribution of the k-th order statistic. Default value is 0.05.}

\item{...}{represents others parameters of a Generalized Pareto distribution.}
}
\value{
A list with a random sample of order statistics from a Generalized Pareto Distribution, the value of its join probability density function evaluated in the random sample and
a (1 - alpha) confidence interval for the population median of the distribution of the k-th order statistic.
}
\description{
\code{order_gpareto} is used to obtain a random sample of the k-th order statistic from a Generalized Pareto distribution and some associated quantities of interest.
}
\examples{
library(orders)
# A sample of size 10 of the 3-th order statistics from a Generalized Pareto Distribution
order_gpareto(size=10,shape1=0.75,shape2=1,scale=0.5,k=3,n=50,alpha=0.02)
}
\references{
Gentle, J, Computational Statistics, First Edition. Springer - Verlag, 2009.

Klugman, S. A., Panjer, H. H. and Willmot, G. E. (2012), Loss Models, From Data to Decisions, Fourth Edition, Wiley.
}
\author{
Carlos Alberto Cardozo Delgado <cardozorpackages@gmail.com>.
}
