% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preparation.R
\name{normalize}
\alias{normalize}
\title{Normalize Outcome/Response to \[0,1\] Interval}
\usage{
normalize(outcome)
}
\arguments{
\item{outcome}{Any non-character vector. Factors will be converted
to numeric via coercion.}
}
\value{
A numeric vector with an upper bound of 1 and a lower bound of
0. The original bounds are saved in the attributes "lower_bound" and
"upper_bound".
}
\description{
This function takes a continuous (double) column of data and converts it
to have 0 as the lower bound and 1 as the upper bound.
}
\details{
Beta regression can only be done with a response that is continuous with a
lower bound of 0 and an upper bound of 1. However, it is
straightforward to transform any lower and upper-bounded continuous
variable to the \[0,1\] interval. This function does the transformation
and saves the original bounds as attributes so that the bounds can be
reverse-transformed.
}
\examples{
# set up arbitrary upper and lower-bounded vector
outcome <- runif(1000, min=-33, max=445)

# normalize to \\[0,1\\]

trans_outcome <- normalize(outcome=outcome)
summary(trans_outcome)

# only works with numeric vectors and factors
\dontrun{
  normalize(outcome=c('a','b'))
}
}
