% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cost_funs.R
\name{total_cost}
\alias{total_cost}
\title{Compute the total cost of raising a certain number of fish until a give time}
\usage{
total_cost(
  time,
  recruits,
  init_cost,
  time_slope,
  time_exp,
  rec_slope,
  rec_exp,
  type = "multiplicative"
)
}
\arguments{
\item{time}{The time at which fish are raised in hatchery}

\item{recruits}{The number of recruits raised}

\item{init_cost}{Baseline initial cost to raise a single fish}

\item{time_slope}{The slope term on the amount of time (see details)}

\item{time_exp}{The exponent on the amount of time}

\item{rec_slope}{The slope term on the number of recruits}

\item{rec_exp}{The exponent on the number of recruits}

\item{type}{Either multiply the number of recruits times the cost-at-time or
add to it (see Details).}
}
\value{
The total cost across time to raise the number of \code{recruits}.
This is simply the integral from time t = 0 until \code{time} of the
\code{\link{cost_fun}} function.
}
\description{
This function takes the definite integral from time t = 0 until the
given \code{time} of the \code{\link{cost_fun}}.
This integral is then the total cost of raising x number of fish until
\code{time} given the other cost function parameters.
}
\examples{
# total cost of raising 1000 fish for 100 days at given parameters
total_cost(time = 100, recruits = 100,
           init_cost = 0.05,
           time_slope = 0.01, time_exp = 1.2,
           rec_slope = 0.05, rec_exp = 1)
}
