% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/opt_alpha_only.R
\name{penoptpersp.alpha.only}
\alias{penoptpersp.alpha.only}
\title{penalized optimization of the constrained linearized perspective function}
\usage{
penoptpersp.alpha.only(y, z, a0, eps = NULL, reltol = NULL, relerr = NULL,
  rho0 = NULL, maxin = NULL, maxout = NULL)
}
\arguments{
\item{y}{length \eqn{n} vector}

\item{z}{\eqn{n \times J} matrix}

\item{a0}{length \eqn{J} vector}

\item{eps}{length \eqn{J} vector, default to be rep(0.1/J, J)}

\item{reltol}{relative tolerence for Newton step, between 0 to 1, default to be \eqn{10^{-3}}. For each inner loop, we optimize \eqn{f_0 + \rho \times \mathrm{pen} } for a fixed \eqn{\rho}, we stop when the Newton decrement \eqn{f(x) - inf_y \hat{f}(y) \leq f(x)* \mathrm{reltol}}, where \eqn{\hat{f}} is the second-order approximation of \eqn{f} at \eqn{x}}

\item{relerr}{relerr stop when within (1+\emph{relerr}) of minimum variance, default to be \eqn{10^{-3}}, between 0 to 1.}

\item{rho0}{initial value for \eqn{\rho}, default to be 1}

\item{maxin}{maximum number of inner iterations}

\item{maxout}{maximum number of outer iterations}
}
\value{
a list of \describe{
  \item{y}{input y}
  \item{z}{input z}
  \item{alpha}{optimized alpha}
  \item{rho}{value of rho}
  \item{f}{value of the objective function}
  \item{rhopen}{value of rho*pen when returned}
  \item{outer}{number of outer loops}
  \item{relerr}{relative error}
  \item{alphasum}{sum of optimized alpha}
}
}
\description{
penalized optimization of the constrained linearized perspective function
}
\details{
To minimize \eqn{\sum_i  \frac{y_i^2}{z_i^T\alpha}} over \eqn{\alpha}
  subject to \eqn{\alpha_j > \epsilon_j} for \eqn{j = 1, \cdots, J} and \eqn{\sum_{j=1}^J \alpha_j < 1},

Instead we minimize \eqn{ \sum_i  \frac{y_i^2}{z_i^T\alpha} + \rho \times \mathrm{pen}} for a decreasing sequence of \eqn{\rho}

where \eqn{ \mathrm{pen} = -( \sum_{j = 1}^J( \log(\alpha_j-\epsilon_j) ) + \log(1-\sum_{j = 1}^J \alpha_j) )}

starting values are \eqn{\alpha = a0} and can be missing.

The optimization stops when within (1+\emph{relerr}) of minimum variance.
}

