% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optionstrat.R
\name{putrho}
\alias{putrho}
\title{Put Rho}
\usage{
putrho(s, x, sigma, t, r, d = 0)
}
\arguments{
\item{s}{Spot price of the underlying asset}

\item{x}{Strike price of the option}

\item{sigma}{Implied volatility of the underlying asset price, defined as the annualized standard deviation of the asset returns}

\item{t}{Time to maturity in years}

\item{r}{Annual continuously-compounded risk-free rate, use the function r.cont}

\item{d}{Annual continuously-compounded dividend yield, use the function r.cont}
}
\value{
Returns the put rho
}
\description{
Calculates the rho of the European- style put option
}
\details{
Rho measures the change in the option's value given a 1% change in the interest rate.
}
\examples{
putrho(100, 100, 0.20, (45/365), 0.02, 0.02)
}
