% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hello.R
\name{plotbearput}
\alias{plotbearput}
\title{Plot Bear Put Spread}
\usage{
plotbearput(s, x1, x2, t, r, sigma, sigma2 = sigma, d = 0, ll = 0.75,
  ul = 1.25, xlab = "spot", ylab = "Profit/Loss",
  main = "Bear Put Spread")
}
\arguments{
\item{s}{Spot price of the underlying asset}

\item{x1}{Lower-strike option price (short option)}

\item{x2}{Higher-strike option price (long option)}

\item{t}{Time to expiration in years}

\item{r}{Annual continuously compounded risk-free rate}

\item{sigma}{Annualized implied volatility of the lower-strike option}

\item{sigma2}{Annualized implied volatility of the higher-strike option}

\item{d}{Annual continuously compounded risk-free rate}

\item{ll}{Lower-limit of the plot, set as (desired price/spot)}

\item{ul}{Upper-limit of the plot, set as (desired price/spot)}

\item{xlab}{X-Axis Label}

\item{ylab}{Y-Axis Label}

\item{main}{Title of the plot}
}
\value{
Returns a plot of a vertical put spread (debit spread).
Black line: The profit(loss) at expiration.
Red line: The profit(loss) at (1/2) time "t" ~ half-way to expiration.
Blue line: The profit(loss) at inception.
}
\description{
Plot a bear put spread (debit spread)
}
\examples{
plotbearput(s= 100, x1 = 95, x2 = 105, t = (45/365), r = 0.02,
sigma = 0.20, sigma2 = 0.20, d = 0, ll = 0.75, ul = 1.25)
}
\author{
John T. Buynak
}
