% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dfp.R
\name{dfp}
\alias{dfp}
\title{Davidon-Fletcher-Powell (DFP) Quasi-Newton Optimization}
\usage{
dfp(
  start,
  objective,
  gradient = NULL,
  hessian = NULL,
  lower = -Inf,
  upper = Inf,
  control = list(),
  ...
)
}
\arguments{
\item{start}{Numeric vector. Starting values for the optimization parameters.}

\item{objective}{Function. The objective function to minimize.}

\item{gradient}{Function (optional). Gradient of the objective function.}

\item{hessian}{Function (optional). Hessian matrix for final verification.}

\item{lower}{Numeric vector. Lower bounds for box constraints.}

\item{upper}{Numeric vector. Upper bounds for box constraints.}

\item{control}{List. Control parameters including convergence flags:
\itemize{
  \item \code{use_abs_f}: Logical. Use absolute change in objective for convergence.
  \item \code{use_rel_f}: Logical. Use relative change in objective for convergence.
  \item \code{use_abs_x}: Logical. Use absolute change in parameters for convergence.
  \item \code{use_rel_x}: Logical. Use relative change in parameters for convergence.
  \item \code{use_grad}: Logical. Use gradient norm for convergence.
  \item \code{use_posdef}: Logical. Verify positive definiteness at convergence.
  \item \code{use_pred_f}: Logical. Record predicted objective decrease.
  \item \code{use_pred_f_avg}: Logical. Record average predicted decrease.
}}

\item{...}{Additional arguments passed to objective, gradient, and Hessian functions.}
}
\value{
A list containing optimization results and iteration metadata.
}
\description{
Implements the DFP Quasi-Newton algorithm with a Strong Wolfe line search and 
optional Powell's damping for non-linear optimization.
}
\details{
\code{dfp} is a Quasi-Newton method that maintains and updates an approximation 
of the inverse Hessian matrix. Historically, it was the first Quasi-Newton 
method discovered (Davidon, 1959) and later refined by Fletcher and Powell (1963).

\bold{DFP vs. BFGS:}
Both DFP and BFGS belong to the Broyden family of Quasi-Newton methods. 
While BFGS is generally preferred for its self-correcting properties regarding 
inaccuracies in the line search, DFP remains a fundamental algorithm that 
can be more sensitive to the local curvature of the objective function. 
In certain Structural Equation Modeling (SEM) contexts, DFP can provide 
alternative convergence paths when BFGS reaches a plateau.

\bold{Strong Wolfe Line Search:}
To ensure the positive definiteness of the inverse Hessian update and guarantee 
global convergence, this implementation employs a Strong Wolfe line search. 
This identifies a step length \eqn{\alpha} that satisfies both:
\itemize{
   \item \bold{Sufficient Decrease (Armijo Rule):} \eqn{f(x + \alpha p) \le f(x) + c_1 \alpha \nabla f(x)^T p}.
   \item \bold{Curvature Condition:} \eqn{| \nabla f(x + \alpha p)^T p | \le c_2 | \nabla f(x)^T p |}.
}

\bold{Powell's Damping Strategy:}
Structural Equation Models often involve non-convex fitting functions. 
When \code{use_damped = TRUE}, the algorithm applies Powell's damping 
to the \eqn{y} vector used in the update formula. This ensures that the curvature 
condition \eqn{s^T y > 0} is maintained even in non-convex regions, preserving 
the stability of the inverse Hessian approximation.
}
\references{
\itemize{
   \item Davidon, W. C. (1959). Variable Metric Method for Minimization. 
         \emph{AEC Research and Development Report}, ANL-5990.
   \item Fletcher, R., & Powell, M. J. D. (1963). A Rapidly Convergent Descent 
         Method for Minimization. \emph{The Computer Journal}, 6(2), 163-168.
   \item Nocedal, J., & Wright, S. J. (2006). \emph{Numerical Optimization}. Springer.
}
}
