% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/is.flag.R
\name{is.flag}
\alias{is.flag}
\alias{which.flag}
\title{Determine if/which vector element are options flags}
\usage{
is.flag(x)

which.flag(x)
}
\arguments{
\item{x}{vector of options, for example \code{commandArgs()}.}
}
\value{
logical. indicating which arguments are flags.

numeric
}
\description{
Determines if an element of a vector is an option flag (as opposed to a
value ) by checking against the option style
}
\details{
\code{is.flag} and \code{which.flag} are internal functions not
expected to be called directly.

They are  used to identify which elements of the option vector are
option names (as opposed to option values). Options are identified by
\code{getOptions('optigrab')$style$flag_test}. By defailt, \emph{optigrab}
follows GNU-style command line arguments, i.e. those beginning with
"--" or "-" and are set at the time of package loading.
}
\examples{
optigrab:::is.flag( c( "--foo", "bar") )
  optigrab:::is.flag( c( "--foo", "bar", "-f", "-b", "text" ) )
optigrab:::which.flag( c( "--foo", "bar") )
  optigrab:::which.flag( c( "--foo", "bar", "-f", "-b", "text" ))
}

