% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-mixture.R
\name{plot.mixture}
\alias{plot.mixture}
\title{Plot an object of class mixture}
\usage{
\method{plot}{mixture}(x, pause = FALSE, col = NULL, ...)
}
\arguments{
\item{x}{an object of class mixture. If awake is provided (i.e., some experts are unactive), 
their residuals and cumulative losses are computed by using the predictions of the mixture.}

\item{pause}{if set to TRUE (default) displays the plots separately, otherwise on a single page}

\item{col}{the color to use to represent each experts, if set to NULL (default) use R\code{RColorBrewer::brewer.pal(...,"Spectral"}}

\item{...}{additional plotting parameters}
}
\value{
plots representing: plot of weights of each expert in function of time, boxplots of these weights,
cumulative loss \eqn{L_T=\sum_{t=1}^T l_{i,t}} of each expert in function of time, cumulative residuals \eqn{\sum_{t=1}^T (y_t-f_{i,t})} of each 
expert's forecast in function of time, average loss suffered by the experts and the contribution of each expert to the aggregation 
\eqn{p_{i,t}f_{i,t}} in function of time.
}
\description{
provides different diagnostic plots for an aggregation procedure.
}
\seealso{
See \code{\link{opera-package}} and opera-vignette for a brief example about how to use the package.
}
\author{
Pierre Gaillard <pierre@gaillard.me>

Yannig  Goude <yannig.goude@edf.fr>
}
