% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper-functions.R
\name{create_sparklines}
\alias{create_sparklines}
\title{Create sparklines object}
\usage{
create_sparklines(
  sheet = current_sheet(),
  dims,
  sqref,
  type = NULL,
  negative = NULL,
  display_empty_cells_as = "gap",
  markers = NULL,
  high = NULL,
  low = NULL,
  first = NULL,
  last = NULL,
  color_series = wb_color(hex = "FF376092"),
  color_negative = wb_color(hex = "FFD00000"),
  color_axis = wb_color(hex = "FFD00000"),
  color_markers = wb_color(hex = "FFD00000"),
  color_first = wb_color(hex = "FFD00000"),
  color_last = wb_color(hex = "FFD00000"),
  color_high = wb_color(hex = "FFD00000"),
  color_low = wb_color(hex = "FFD00000"),
  manual_max = NULL,
  manual_min = NULL,
  line_weight = NULL,
  date_axis = NULL,
  display_x_axis = NULL,
  display_hidden = NULL,
  min_axis_type = NULL,
  max_axis_type = NULL,
  right_to_left = NULL,
  ...
)
}
\arguments{
\item{sheet}{sheet}

\item{dims}{Cell range of cells used to create the sparklines}

\item{sqref}{Cell range of the destination of the sparklines.}

\item{type}{Either \code{NULL}, \code{stacked} or \code{column}}

\item{negative}{negative}

\item{display_empty_cells_as}{Either \code{gap}, \code{span} or \code{zero}}

\item{markers}{markers add marker to line}

\item{high}{highlight highest value}

\item{low}{highlight lowest value}

\item{first}{highlight first value}

\item{last}{highlight last value}

\item{color_series}{colorSeries}

\item{color_negative}{colorNegative}

\item{color_axis}{colorAxis}

\item{color_markers}{colorMarkers}

\item{color_first}{colorFirst}

\item{color_last}{colorLast}

\item{color_high}{colorHigh}

\item{color_low}{colorLow}

\item{manual_max}{manualMax}

\item{manual_min}{manualMin}

\item{line_weight}{lineWeight}

\item{date_axis}{dateAxis}

\item{display_x_axis}{displayXAxis}

\item{display_hidden}{displayHidden}

\item{min_axis_type}{minAxisType}

\item{max_axis_type}{maxAxisType}

\item{right_to_left}{rightToLeft}

\item{...}{additional arguments}
}
\value{
A string containing XML code
}
\description{
Create a sparkline to be added a workbook with \code{\link[=wb_add_sparklines]{wb_add_sparklines()}}
}
\details{
Colors are all predefined to be rgb. Maybe theme colors can be
used too.
}
\examples{
# create sparklineGroup
sparklines <- c(
  create_sparklines("Sheet 1", "A3:L3", "M3", type = "column", first = "1"),
  create_sparklines("Sheet 1", "A2:L2", "M2", markers = "1"),
  create_sparklines("Sheet 1", "A4:L4", "M4", type = "stacked", negative = "1")
)

t1 <- AirPassengers
t2 <- do.call(cbind, split(t1, cycle(t1)))
dimnames(t2) <- dimnames(.preformat.ts(t1))

wb <- wb_workbook()$
  add_worksheet("Sheet 1")$
  add_data(x = t2)$
  add_sparklines(sparklines = sparklines)

}
