% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writeDataTable.R
\name{writeDataTable}
\alias{writeDataTable}
\title{Write to a worksheet as an Excel table}
\usage{
writeDataTable(wb, sheet, x, startCol = 1, startRow = 1, xy = NULL,
  colNames = TRUE, rowNames = FALSE, tableStyle = "TableStyleLight9",
  tableName = NULL, headerStyle = NULL, withFilter = TRUE,
  keepNA = FALSE, sep = ", ", stack = FALSE, firstColumn = FALSE,
  lastColumn = FALSE, bandedRows = TRUE, bandedCols = FALSE)
}
\arguments{
\item{wb}{A Workbook object containing a 
worksheet.}

\item{sheet}{The worksheet to write to. Can be the worksheet index or name.}

\item{x}{A dataframe.}

\item{startCol}{A vector specifiying the starting column to write df}

\item{startRow}{A vector specifiying the starting row to write df}

\item{xy}{An alternative to specifying startCol and startRow individually.
A vector of the form c(startCol, startRow)}

\item{colNames}{If \code{TRUE}, column names of x are written.}

\item{rowNames}{If \code{TRUE}, row names of x are written.}

\item{tableStyle}{Any excel table style name or "none" (see "formatting" vignette).}

\item{tableName}{name of table in workbook. The table name must be unique.}

\item{headerStyle}{Custom style to apply to column names.}

\item{withFilter}{If \code{TRUE}, columns with have filters in the first row.}

\item{keepNA}{If \code{TRUE}, NA values are converted to #N/A in Excel else NA cells will be empty.}

\item{sep}{Only applies to list columns. The seperator used to collapse list columns to a character vector e.g. sapply(x$list_column, paste, collapse = sep).
\cr\cr
\cr\bold{The below options correspond to Excel table options:}
\cr
\if{html}{\figure{tableoptions.png}{options: width="40\%" alt="Figure: table_options.png"}}
\if{latex}{\figure{tableoptions.pdf}{options: width=7cm}}}

\item{stack}{If \code{TRUE} the new style is merged with any existing cell styles.  If FALSE, any 
existing style is replaced by the new style.}

\item{firstColumn}{logical. If TRUE, the first column is bold}

\item{lastColumn}{logical. If TRUE, the last column is bold}

\item{bandedRows}{logical. If TRUE, rows are colour banded}

\item{bandedCols}{logical. If TRUE, the columns are colour banded}
}
\description{
Write to a worksheet and format as an Excel table
}
\details{
columns of x with class Date/POSIXt, currency, accounting, 
hyperlink, percentage are automatically styled as dates, currency, accounting,
hyperlinks, percentages respectively.
}
\examples{
## see package vignettes for further examples.

#####################################################################################
## Create Workbook object and add worksheets
wb <- createWorkbook()
addWorksheet(wb, "S1")
addWorksheet(wb, "S2")
addWorksheet(wb, "S3")


#####################################################################################
## -- write data.frame as an Excel table with column filters
## -- default table style is "TableStyleMedium2"

writeDataTable(wb, "S1", x = iris)

writeDataTable(wb, "S2", x = mtcars, xy = c("B", 3), rowNames = TRUE,
  tableStyle = "TableStyleLight9")

df <- data.frame("Date" = Sys.Date()-0:19,
                 "T" = TRUE, "F" = FALSE,
                 "Time" = Sys.time()-0:19*60*60,
                 "Cash" = paste("$",1:20), "Cash2" = 31:50,
                 "hLink" = "https://CRAN.R-project.org/", 
                 "Percentage" = seq(0, 1, length.out=20),
                 "TinyNumbers" = runif(20) / 1E9,  stringsAsFactors = FALSE)

## openxlsx will apply default Excel styling for these classes
class(df$Cash) <- c(class(df$Cash), "currency")
class(df$Cash2) <- c(class(df$Cash2), "accounting")
class(df$hLink) <- "hyperlink"
class(df$Percentage) <- c(class(df$Percentage), "percentage")
class(df$TinyNumbers) <- c(class(df$TinyNumbers), "scientific")

writeDataTable(wb, "S3", x = df, startRow = 4, rowNames = TRUE, tableStyle = "TableStyleMedium9")

#####################################################################################
## Additional Header Styling and remove column filters

writeDataTable(wb, sheet = 1, x = iris, startCol = 7, headerStyle = createStyle(textRotation = 45),
                 withFilter = FALSE)


##################################################################################### 
## Save workbook
## Open in excel without saving file: openXL(wb)

saveWorkbook(wb, "writeDataTableExample.xlsx", overwrite = TRUE)
}
\seealso{
\code{\link{addWorksheet}}

\code{\link{writeData}}

\code{\link{removeTable}}

\code{\link{getTables}}
}
\author{
Alexander Walker
}
