% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oaAuthors2df.R
\name{oaAuthors2df}
\alias{oaAuthors2df}
\title{Convert OpenAlex collection of authors' records from list format to data frame}
\usage{
oaAuthors2df(data, verbose = TRUE)
}
\arguments{
\item{data}{is a list. data is the output of the function \code{oaApiRequest}.}

\item{verbose}{is a logical. If TRUE, information about the querying process will be plotted on screen. Default is \code{verbose=TRUE}.}
}
\value{
a data.frame.

For more extensive information about OpenAlex API, please visit: \href{https://docs.openalex.org/api}{https://docs.openalex.org/api}
}
\description{
It converts bibliographic collection of authors' records gathered from OpenAlex database \href{https://openalex.org/}{https://openalex.org/} into data frame.
The function converts a list of authors' records obtained using \code{oaApiRequest} into a data frame/tibble.
}
\examples{

\dontrun{

# Query to search information about all authors affiliated to the University of Naples Federico II
# which have authored at least 100 publications:

# University of Naples Federico II is associated to the OpenAlex id I71267560.


query_author <- oaQueryBuild(
 identifier = NULL,
 entity = "authors",
 filter = "last_known_institution.id:I71267560,works_count:>99")

res <- oaApiRequest(
   query_url = query_author,
   total.count = FALSE,
   verbose = FALSE
   )

df <- oa2df(res, entity = "authors")

df

}

}
