% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oa_readme.R
\name{oa_readme}
\alias{oa_readme}
\title{Print readme from one or more datasets}
\usage{
oa_readme(x)
}
\arguments{
\item{x}{input, either an object of class \code{oa} or a list of such
objects}
}
\value{
character string
}
\description{
Print readme from one or more datasets
}
\examples{
\dontrun{
# single
url1 <- "http://data.openaddresses.io/runs/33311/us/mi/ottawa.zip"
xx <- oa_get(url1)
oa_readme(xx)
cat(oa_readme(xx))

# many at once
url2 <- "http://data.openaddresses.io/runs/101436/us/ca/yolo.zip"
zz <- oa_get(url2)
oa_readme(list(xx, zz))
cat(oa_readme(list(xx, zz)), sep = "\\n\\n")
}
}

