% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correct_compl_confluences.R
\name{correct_compl_confluences}
\alias{correct_compl_confluences}
\title{Correct confluences with three or more inflows.}
\usage{
correct_compl_confluences(clean = TRUE)
}
\arguments{
\item{clean}{logical; should intermediate files be removed from 'GRASS'
session?}
}
\value{
Nothing. The function changes features in 'streams_v'. Changed features are
marked in the new column 'changed'.
}
\description{
At complex confluences (when more than two line segments flow into a node,
i.e. more than two inflows to an outflow), the end of one of the inflows is moved a 
tiny bit upstream to one of the other inflows to create a new confluence of
two streams (see details below).
}
\details{
At complex confluences (when more than two line segments flow into a node,
i.e. more than two inflows to an outflow), new confluences of only two streams 
are created:
1. complex confluences are found based on the fact that the outflow has more than
two previous streams
2. the inflow with the shortest cumulative length from its source  is found; 
the end of this segment will be moved
3. the inflow with the smallest angle to this inflow is found;
this segment will be cut into tow segments close to the junction using the GRASS function
\href{https://grass.osgeo.org/grass78/manuals/v.edit.html}{v.edit}(tool =
break) creating a new confluence
4. the shortest inflow found in 2 is moved to the newly created confluence using
\href{https://grass.osgeo.org/grass78/manuals/v.edit.html}{v.edit}(tool =
vertexmove)
5. all lengths are updated (segment length, cumulative length, i.e. length of the stream
from the source, distance to the outlet).
The distance the shortest confluence is moved depends on the number of inflows. For three 
inflows, it is moved 1/12 time the DEM cellsize upstream, for seven (the extremely rare maximum)
5/12 * cellsize.
}
\note{
\code{\link{setup_grass_environment}}, \code{\link{import_data}} and
  \code{\link{derive_streams}} must be run before.
}
\examples{
\donttest{
# Initiate and setup GRASS
dem_path <- system.file("extdata", "nc", "elev_ned_30m.tif", package = "openSTARS")
if(.Platform$OS.type == "windows"){
  grass_program_path = "c:/Program Files/GRASS GIS 7.6"
  } else {
  grass_program_path = "/usr/lib/grass78/"
  }

setup_grass_environment(dem = dem_path, 
                        gisBase = grass_program_path,      
                        remove_GISRC = TRUE,
                        override = TRUE
                        )
gmeta()

# Load files into GRASS
dem_path <- system.file("extdata", "nc", "elev_ned_30m.tif", package = "openSTARS")
sites_path <- system.file("extdata", "nc", "sites_nc.shp", package = "openSTARS")
streams_path <- system.file("extdata", "nc", "streams.shp", package = "openSTARS")
import_data(dem = dem_path, sites = sites_path, streams = streams_path)

# Derive streams from DEM
derive_streams(burn = 10, accum_threshold = 100, condition = TRUE, clean = TRUE)

# Check and correct complex confluences (there are complex confluences in the 
# example date set if the accumulation threshold is low)
cj <- check_compl_confluences()
if(cj){
  correct_compl_confluences()
}

# plot
library(sp)
dem <- readRAST('dem', ignore.stderr = TRUE, plugin = FALSE)
streams <- readVECT('streams_v', ignore.stderr = TRUE)
streams_orig <- readVECT('streams_v_o3', ignore.stderr = TRUE)
# zoom to a relevant part of the dem
plot(dem, col = terrain.colors(20), axes = TRUE, 
  xlim = c(640100,640150), ylim = c(219735,219785))
lines(streams_orig, col = 'red', lwd = 4)
lines(streams, col = 'blue', lty = 2, lwd = 2)
legend("bottomright", col = c("red", "blue"), lty = c(1,2), lwd = c(4,2), 
  legend = c("original", "corrected"))
  
plot(streams, col = c("blue", "red")[streams@data$changed+1], lty = 1, lwd = 2)   
}
}
\author{
Mira Kattwinkel \email{mira.kattwinkel@gmx.net}
}
