% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_edges.R
\name{calc_edges}
\alias{calc_edges}
\title{Calculate edges for SSN object.}
\usage{
calc_edges()
}
\value{
Nothing. The function produces the following map: \itemize{
 \item{'edges':} {derived stream segments with computed attributes needed for
 'SSN' (vector)} }
}
\description{
A vector (lines) map 'edges' is derived from 'streams_v' and
 several attributes are assigned.
}
\details{
Steps include:
\itemize{ \item{Assign unique 'rid' to each stream segment}
\item{Find different stream networks in the region and assign 'netID'}
\item{Calculate segments upstream distance, 'upDist' = flow length from the 
upstream node of the stream segment to the outlet of the network}
\item{Calculate reach contributing areas (RCA ) per segment,
'rcaArea' = subcatchment area of each segment in square km}
\item{Calculate catchment areas, 'H2OArea' = total catchment area of each
segment in square km} }
All lengths are rounded to 2 and all areas to 6 decimal places, respectively.
}
\note{
\code{\link{setup_grass_environment}}, \code{\link{import_data}} and
 \code{\link{derive_streams}} must be run before.
}
\examples{
\donttest{
# Initiate GRASS session
if(.Platform$OS.type == "windows"){
  gisbase = "c:/Program Files/GRASS GIS 7.6"
  } else {
  gisbase = "/usr/lib/grass74/"
  }
initGRASS(gisBase = gisbase,
    home = tempdir(),
    override = TRUE)

# Load files into GRASS
dem_path <- system.file("extdata", "nc", "elev_ned_30m.tif", package = "openSTARS")
sites_path <- system.file("extdata", "nc", "sites_nc.shp", package = "openSTARS")
setup_grass_environment(dem = dem_path)
import_data(dem = dem_path, sites = sites_path)
gmeta()

# Derive streams from DEM
derive_streams(burn = 0, accum_threshold = 700, condition = TRUE, clean = TRUE)

check_compl_confluences()

# Prepare edges
calc_edges()

# Plot data
library(sp)
dem <- readRAST('dem', ignore.stderr = TRUE)
edges <- readVECT('edges', ignore.stderr = TRUE)
plot(dem, col = terrain.colors(20))
lines(edges, col = 'blue')
}

}
\author{
Mira Kattwinkel, \email{mira.kattwinkel@gmx.net}, 
 Eduard Szoecs, \email{eduardszoecs@gmail.com}
}
