/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.lang.english;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import opennlp.tools.coref.DiscourseEntity;
import opennlp.tools.coref.mention.DefaultParse;
import opennlp.tools.coref.mention.MentionContext;
import opennlp.tools.parser.Parse;
import opennlp.tools.util.Span;

class CorefParse {
    private Map parseMap;
    private List parses;

    public CorefParse(List parses, DiscourseEntity[] entities) {
        this.parses = parses;
        this.parseMap = new HashMap();
        int en = entities.length;
        for (int ei = 0; ei < en; ++ei) {
            if (entities[ei].getNumMentions() <= 1) continue;
            Iterator mi = entities[ei].getMentions();
            while (mi.hasNext()) {
                MentionContext mc = (MentionContext)mi.next();
                Parse mentionParse = ((DefaultParse)mc.getParse()).getParse();
                this.parseMap.put(mentionParse, new Integer(ei + 1));
            }
        }
    }

    public void show() {
        int pn = this.parses.size();
        for (int pi = 0; pi < pn; ++pi) {
            Parse p = (Parse)this.parses.get(pi);
            this.show(p);
            System.out.println();
        }
    }

    private void show(Parse p) {
        int start = p.getSpan().getStart();
        if (!p.getType().equals("TK")) {
            System.out.print("(");
            System.out.print(p.getType());
            if (this.parseMap.containsKey(p)) {
                System.out.print("#" + this.parseMap.get(p));
            }
            System.out.print(" ");
        }
        for (Parse c : p.getChildren()) {
            Span s = c.getSpan();
            if (start < s.getStart()) {
                System.out.print(p.getText().substring(start, s.getStart()));
            }
            this.show(c);
            start = s.getEnd();
        }
        System.out.print(p.getText().substring(start, p.getSpan().getEnd()));
        if (!p.getType().equals("TK")) {
            System.out.print(")");
        }
    }
}

