/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.tokenize;

import java.util.ArrayList;
import java.util.List;
import opennlp.maxent.ContextGenerator;
import opennlp.maxent.Event;
import opennlp.maxent.EventStream;
import opennlp.tools.tokenize.TokContextGenerator;
import opennlp.tools.tokenize.TokenizerME;
import opennlp.tools.util.ObjectIntPair;
import opennlp.tools.util.Span;

public class TokSpanEventStream
implements EventStream {
    private static final ContextGenerator cg = new TokContextGenerator();
    private List events;
    private int eventIndex;
    private boolean skipAlphaNumerics;

    public TokSpanEventStream(boolean skipAlphaNumerics) {
        this.skipAlphaNumerics = skipAlphaNumerics;
        this.events = new ArrayList(50);
        this.eventIndex = 0;
    }

    public void addEvents(Span[] tokens, String text) {
        if (tokens.length > 0) {
            int start = tokens[0].getStart();
            int end = tokens[tokens.length - 1].getEnd();
            String sent = text.substring(start, end);
            Span[] candTokens = TokenizerME.split(sent);
            int firstTrainingToken = -1;
            int lastTrainingToken = -1;
            for (int ci = 0; ci < candTokens.length; ++ci) {
                int ti;
                Span cSpan = candTokens[ci];
                String ctok = sent.substring(cSpan.getStart(), cSpan.getEnd());
                cSpan = new Span(cSpan.getStart() + start, cSpan.getEnd() + start);
                if (ctok.length() <= 1 || this.skipAlphaNumerics && TokenizerME.alphaNumeric.matcher(ctok).matches()) continue;
                boolean foundTrainingTokens = false;
                for (ti = lastTrainingToken + 1; ti < tokens.length; ++ti) {
                    if (cSpan.contains(tokens[ti])) {
                        if (!foundTrainingTokens) {
                            firstTrainingToken = ti;
                            foundTrainingTokens = true;
                        }
                        lastTrainingToken = ti;
                        continue;
                    }
                    if (cSpan.getEnd() < tokens[ti].getEnd()) break;
                    if (tokens[ti].getEnd() < cSpan.getStart()) continue;
                    System.err.println("Bad training token: " + tokens[ti] + " cand: " + cSpan);
                }
                if (!foundTrainingTokens) continue;
                for (ti = firstTrainingToken; ti <= lastTrainingToken; ++ti) {
                    Span tSpan = tokens[ti];
                    int cStart = cSpan.getStart();
                    for (int i = tSpan.getStart() + 1; i < tSpan.getEnd(); ++i) {
                        String[] context = cg.getContext((Object)new ObjectIntPair(ctok, i - cStart));
                        this.events.add(new Event("F", context));
                    }
                    if (tSpan.getEnd() == cSpan.getEnd()) continue;
                    String[] context = cg.getContext((Object)new ObjectIntPair(ctok, tSpan.getEnd() - cStart));
                    this.events.add(new Event("T", context));
                }
            }
        }
    }

    public boolean hasNext() {
        return this.eventIndex < this.events.size();
    }

    public Event nextEvent() {
        Event e = (Event)this.events.get(this.eventIndex);
        ++this.eventIndex;
        if (this.eventIndex == this.events.size()) {
            this.events.clear();
            this.eventIndex = 0;
        }
        return e;
    }
}

