/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.postag;

import java.util.ArrayList;
import java.util.regex.Pattern;
import opennlp.tools.ngram.Dictionary;
import opennlp.tools.postag.POSContextGenerator;
import opennlp.tools.util.Cache;

public class DefaultPOSContextGenerator
implements POSContextGenerator {
    protected final String SE = "*SE*";
    protected final String SB = "*SB*";
    private static final int PREFIX_LENGTH = 4;
    private static final int SUFFIX_LENGTH = 4;
    private static Pattern hasCap = Pattern.compile("[A-Z]");
    private static Pattern hasNum = Pattern.compile("[0-9]");
    private Cache contextsCache;
    private Object wordsKey;
    private Dictionary dict;
    private String[] dictGram;

    public DefaultPOSContextGenerator(Dictionary dict) {
        this(0, dict);
    }

    public DefaultPOSContextGenerator(int cacheSize, Dictionary dict) {
        this.dict = dict;
        this.dictGram = new String[1];
        if (cacheSize > 0) {
            this.contextsCache = new Cache(cacheSize);
        }
    }

    public String[] getContext(Object o) {
        Object[] data = (Object[])o;
        return this.getContext((Integer)data[0], (Object[])data[1], (String[])data[2], null);
    }

    protected static String[] getPrefixes(String lex) {
        String[] prefs = new String[4];
        int ll = 4;
        for (int li = 0; li < ll; ++li) {
            prefs[li] = lex.substring(0, Math.min(li + 1, lex.length()));
        }
        return prefs;
    }

    protected static String[] getSuffixes(String lex) {
        String[] suffs = new String[4];
        int ll = 4;
        for (int li = 0; li < ll; ++li) {
            suffs[li] = lex.substring(Math.max(lex.length() - li - 1, 0));
        }
        return suffs;
    }

    public String[] getContext(int index, Object[] sequence, String[] priorDecisions, Object[] additionalContext) {
        return this.getContext(index, sequence, priorDecisions);
    }

    public String[] getContext(int index, Object[] tokens, String[] tags) {
        String tagprevprev = null;
        String tagprev = null;
        String prevprev = null;
        String prev = null;
        String lex = null;
        String nextnext = null;
        String next = null;
        lex = tokens[index].toString();
        if (tokens.length > index + 1) {
            next = tokens[index + 1].toString();
            nextnext = tokens.length > index + 2 ? tokens[index + 2].toString() : "*SE*";
        } else {
            next = "*SE*";
        }
        if (index - 1 >= 0) {
            prev = tokens[index - 1].toString();
            tagprev = tags[index - 1].toString();
            if (index - 2 >= 0) {
                prevprev = tokens[index - 2].toString();
                tagprevprev = tags[index - 2].toString();
            } else {
                prevprev = "*SB*";
            }
        } else {
            prev = "*SB*";
        }
        String cacheKey = index + tagprev + tagprevprev;
        if (this.contextsCache != null) {
            if (this.wordsKey == tokens) {
                String[] cachedContexts = (String[])this.contextsCache.get(cacheKey);
                if (cachedContexts != null) {
                    return cachedContexts;
                }
            } else {
                this.contextsCache.clear();
                this.wordsKey = tokens;
            }
        }
        ArrayList<String> e = new ArrayList<String>();
        e.add("def");
        e.add("w=" + lex);
        this.dictGram[0] = lex;
        if (this.dict == null || !this.dict.contains(this.dictGram)) {
            String[] suffs = DefaultPOSContextGenerator.getSuffixes(lex);
            for (int i = 0; i < suffs.length; ++i) {
                e.add("suf=" + suffs[i]);
            }
            String[] prefs = DefaultPOSContextGenerator.getPrefixes(lex);
            for (int i = 0; i < prefs.length; ++i) {
                e.add("pre=" + prefs[i]);
            }
            if (lex.indexOf(45) != -1) {
                e.add("h");
            }
            if (hasCap.matcher(lex).find()) {
                e.add("c");
            }
            if (hasNum.matcher(lex).find()) {
                e.add("d");
            }
        }
        if (prev != null) {
            e.add("p=" + prev);
            if (tagprev != null) {
                e.add("t=" + tagprev);
            }
            if (prevprev != null) {
                e.add("pp=" + prevprev);
                if (tagprevprev != null) {
                    e.add("t2=" + tagprevprev + "," + tagprev);
                }
            }
        }
        if (next != null) {
            e.add("n=" + next);
            if (nextnext != null) {
                e.add("nn=" + nextnext);
            }
        }
        String[] contexts = e.toArray(new String[e.size()]);
        if (this.contextsCache != null) {
            this.contextsCache.put(cacheKey, contexts);
        }
        return contexts;
    }
}

