% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_likelihoodEqs.R
\name{negLLzeroSquash}
\alias{negLLzeroSquash}
\title{Likelihood with data squashing & zero counts}
\usage{
negLLzeroSquash(theta, ni, ei, wi)
}
\arguments{
\item{theta}{A numeric vector of hyperparameters ordered as:
\eqn{\alpha_1, \beta_1, \alpha_2, \beta_2, P}.}

\item{ni}{A whole number vector of squashed actual counts from
\code{\link{squashData}}.}

\item{ei}{A numeric vector of squashed expected counts from
\code{\link{squashData}}.}

\item{wi}{A whole number vector of bin weights from \code{\link{squashData}}.}
}
\value{
A scalar negative log-likelihood value.
}
\description{
\code{negLLzeroSquash} computes the negative log-likelihood based on the
unconditional marginal distribution of \emph{N} (DuMouchel et al. 2001).
This function is minimized to estimate the hyperparameters of the prior
distribution. Use this function if including zero counts and using data
squashing. Generally this function is not recommended unless convergence
issues occur without zero counts (\code{\link{negLLsquash}} is typically more
efficient).
}
\details{
The marginal distribution of the counts, \emph{N}, is a mixture of
  two negative binomial distributions. The hyperparameters for the prior
  distribution (mixture of gammas) are estimated by optimizing the likelihood
  equation from this marginal distribution.

The hyperparameters are:
  \itemize{
    \item{\eqn{\alpha_1, \beta_1}: }{Parameters of the first component of the
      marginal distribution of the counts (also the prior distribution)}
    \item{\eqn{\alpha_2, \beta_2}: }{Parameters of the second component}
    \item{\eqn{P}: }{Mixture fraction}
}

This function will not need to be called directly if using
  \code{\link{exploreHypers}} or \code{\link{autoHyper}}.
}
\section{Warnings}{

  Make sure \emph{ni} actually contains zeroes before using this function.
  You should have used the \code{zeroes = TRUE} option when calling the
  \code{processRaw} function.


  Make sure the data were actually squashed (see \code{\link{squashData}})
  before using this function.
}

\references{
DuMouchel W, Pregibon D (2001). "Empirical Bayes Screening for
  Multi-item Associations." In \emph{Proceedings of the Seventh ACM SIGKDD
  International Conference on Knowledge Discovery and Data Mining}, KDD '01,
  pp. 67-76. ACM, New York, NY, USA. ISBN 1-58113-391-X.
}
\seealso{
\code{\link[stats]{nlm}}, \code{\link[stats]{nlminb}}, and
  \code{\link[stats]{optim}} for optimization and \code{\link{squashData}}
  for data squashing

Other negative log-likelihood functions: \code{\link{negLLsquash}},
  \code{\link{negLLzero}}, \code{\link{negLL}}
}
\keyword{openEBGM}
