% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datashield.admin.R
\name{dsadmin.package_description}
\alias{dsadmin.package_description}
\title{Get DataSHIELD package description}
\usage{
dsadmin.package_description(opal, pkg, fields = NULL, profile = NULL)
}
\arguments{
\item{opal}{Opal object or list of opal objects.}

\item{pkg}{Package name.}

\item{fields}{A character vector giving the fields to extract from each package's
DESCRIPTION file in addition to the default ones, or NULL (default). Unavailable fields result in NA values.}

\item{profile}{The DataSHIELD profile name to which operation applies. See also \link{dsadmin.profiles}.}
}
\description{
Get DataSHIELD package description
}
\examples{
\dontrun{
o <- opal.login('administrator','password', url='https://opal-demo.obiba.org')
dsadmin.package_description(o, 'dsBase')
opal.logout(o)
}
}
\seealso{
Other DataSHIELD functions: 
\code{\link{dsadmin.get_method}()},
\code{\link{dsadmin.get_methods}()},
\code{\link{dsadmin.get_options}()},
\code{\link{dsadmin.install_github_package}()},
\code{\link{dsadmin.install_local_package}()},
\code{\link{dsadmin.install_package}()},
\code{\link{dsadmin.installed_package}()},
\code{\link{dsadmin.package_descriptions}()},
\code{\link{dsadmin.publish_package}()},
\code{\link{dsadmin.remove_package}()},
\code{\link{dsadmin.rm_method}()},
\code{\link{dsadmin.rm_methods}()},
\code{\link{dsadmin.rm_option}()},
\code{\link{dsadmin.rm_options}()},
\code{\link{dsadmin.rm_package_methods}()},
\code{\link{dsadmin.set_method}()},
\code{\link{dsadmin.set_option}()},
\code{\link{dsadmin.set_package_methods}()},
\code{\link{dsadmin.unpublish_package}()}
}
\concept{DataSHIELD functions}
