% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opal.annotations.R
\name{opal.annotations}
\alias{opal.annotations}
\title{Get the annotations of a Opal table}
\usage{
opal.annotations(opal, datasource, table)
}
\arguments{
\item{opal}{Opal object.}

\item{datasource}{Name of the datasource.}

\item{table}{Name of the table in the datasource.}
}
\value{
A data frame in long format (one row per annotation).
}
\description{
Directly retrieves from the table's data dictionary the variable annotations (attributes with a namespace).
}
\examples{
\dontrun{
o <- opal.login('administrator','password', url='https://opal-demo.obiba.org')
opal.annotations(o, 'CPTP', 'Coreqx_final')
opal.logout(o)
}
}
\seealso{
Other datasource functions: 
\code{\link{opal.annotate}()},
\code{\link{opal.attribute_values}()},
\code{\link{opal.datasources}()},
\code{\link{opal.datasource}()},
\code{\link{opal.tables}()},
\code{\link{opal.table}()},
\code{\link{opal.valueset}()},
\code{\link{opal.variables}()},
\code{\link{opal.variable}()}
}
\concept{datasource functions}
