% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opal.file.r
\name{opal.file_download}
\alias{opal.file_download}
\title{Download a file}
\usage{
opal.file_download(opal, source, destination = NULL, key = NULL)
}
\arguments{
\item{opal}{Opal object.}

\item{source}{Path to the file in the Opal file system.}

\item{destination}{Path to the file to be written. If ommitted, file with same name in the working directory will be written.}

\item{key}{File encryption key: downloaded file will be a zip file with content encrypted (use 7zip to decrypt).}
}
\description{
Download a file or a folder from the Opal file system.
}
\examples{
\dontrun{
o <- opal.login('administrator','password','https://opal-demo.obiba.org')
# download a file
opal.file_download(o, '/home/administrator/joins/join-src-3.csv')
# download a file encrypted by a key: resulting file is a zip with an encrypted content
opal.file_download(o, '/home/administrator/export/some-data.csv', 
                      destination='some-data.zip', key='AZF57893FBDE')
# download, create destination folder and rename file
opal.file_download(o, '/home/administrator/spss/DatabaseTest.sav', 'spss/test.sav')
# download a folder
opal.file_download(o, '/home/administrator/export', 'export.zip')
opal.logout(o)
}
}
\seealso{
Other file functions: \code{\link{opal.file_cp}},
  \code{\link{opal.file_ls}},
  \code{\link{opal.file_mkdir}},
  \code{\link{opal.file_mv}}, \code{\link{opal.file_read}},
  \code{\link{opal.file_rm}},
  \code{\link{opal.file_upload}},
  \code{\link{opal.file_write}}, \code{\link{opal.file}}
}
\concept{file functions}
