% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sets.R
\name{get_term_frequencies}
\alias{get_term_frequencies}
\title{Get frequency of each term in a set of phenotypes}
\usage{
get_term_frequencies(ontology, term_sets, patch_missing = FALSE)
}
\arguments{
\item{ontology}{\code{ontology_index} object.}

\item{term_sets}{List of character vectors of ontological term IDs.}

\item{patch_missing}{Logical indicating whether to include whole ontology even if they're not present in the \code{term_sets} as if they had occurred once}
}
\value{
Numeric vector of information contents, named by corresponding terms. Takes into account ancestors, in the sense that all ancestor terms implied by the phenotypes are considered 'on'
}
\description{
Get frequency of each term in a set of phenotypes
}
\examples{
data(hpo)
get_term_frequencies(hpo, list("HP:0001873"))
}
\seealso{
\code{\link{get_term_info_content}}
}

