% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/score.R
\name{score}
\alias{score}
\alias{score.list}
\alias{score.data.frame}
\title{Calculate the score for each horizon.}
\usage{
score(object, scoreperiod = NA, usecomplete = TRUE, scorefun = rmse, ...)

\method{score}{list}(object, scoreperiod = NA, usecomplete = TRUE, scorefun = rmse, ...)

\method{score}{data.frame}(object, scoreperiod = NA, usecomplete = TRUE, scorefun = rmse, ...)
}
\arguments{
\item{object}{??list or A matrix with residuals (columns named \code{hxx}) for which to calculate the score for each horizon.}

\item{scoreperiod}{as a logical vector controlling which points to be included in the score calculation. If NA then all values are included (depeding on 'complete').}

\item{usecomplete}{TRUE then only the values available for all horizons are included (i.e. if at one time point there is a missing value, then values for this time point is removed for all horizons in the calculation).}

\item{scorefun}{The score function.}

\item{...}{is passed on to the score function.}
}
\value{
A list with the a numeric vector with the score value for each horizon and the applied \code{scoreperiod} (note can be different from the given scoreperiod, if only complete observations are used (as per default)).
}
\description{
Calculates the score for each horizon for a matrix with residuals for each horizon.
}
\details{
Applies the \code{scorefun} on all horizons (each column) of the residuals matrix. See the description of each parameter for more details.
}
\examples{

# Just a vector to be forecasted
y <- c(filter(rnorm(100), 0.95, "recursive"))
# Generate a forecast matrix with a simple persistence model
Yhat <- persistence(y, kseq=1:4)
# The residuals for each horizon
Resid <- residuals(Yhat, y)

# Calculate the score for the k1 horizon
score(Resid)

# In the beginning the horizons have NAs
head(Resid)
# Default is that only complete cases over all horizons are included
score(Resid)
# So including all cases for each horizon will give different values
score(Resid, usecomplete=FALSE)

# Given a list
# The residuals for each horizon
Resid2 <- residuals(persistence(y,kseq=1:4)+rnorm(100), y)

score(list(Resid,Resid2))
}
