% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_token.R
\name{get_token}
\alias{get_token}
\title{Extract API token from OneMap.Sg}
\usage{
get_token(email, password, hide_message = FALSE)
}
\arguments{
\item{email}{User's registered email address.}

\item{password}{User's password.}

\item{hide_message}{Default = \code{FALSE}. Whether to hide message telling user when the token expires.}
}
\value{
API token, or NULL if an error occurs. If error occurs, a warning message will be printed with the error code.
}
\description{
This function is a wrapper for the \href{https://docs.onemap.sg/#authentication-service-post}{OneMap Authentication Service API}. It allows users to generate a API token from OneMap.Sg.
Using the API requires that users have a registered email address with Onemap.Sg. Users can register themselves using \href{https://developers.onemap.sg/signup/}{OneMap.Sg's form}.
}
\examples{
\dontrun{get_token("user@example.com",  "password")}
}
