% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{add_marker}
\alias{add_marker}
\title{Creates a new sequence by adding markers.}
\usage{
add_marker(input.seq, mrks)
}
\arguments{
\item{input.seq}{an object of class \code{sequence}.}

\item{mrks}{a vector containing the markers to be added from the
\code{sequence}.}
}
\value{
An object of class \code{sequence}, which is a list
    containing the following components:

\item{seq.num}{a \code{vector} containing the (ordered) indices of
    markers in the sequence, according to the input file.}

\item{seq.phases}{a \code{vector} with the linkage phases between
    markers in the sequence, in corresponding positions. \code{-1}
    means that there are no defined linkage phases.}

\item{seq.rf}{a \code{vector} with the recombination fractions
    between markers in the sequence. \code{-1} means that there
    are no estimated recombination fractions.}

\item{seq.like}{log-likelihood of the corresponding linkage map.}
    \item{data.name}{name of the object of class \code{onemap}
    with the raw data.}

\item{twopt}{name of the object of class \code{rf_2pts} with the
    2-point analyses.}

 @author Marcelo Mollinari, \email{mmollina@usp.br}
}
\description{
Creates a new sequence by adding markers from a predetermined
  one. The markers are added in the end of the sequence.
}
\examples{
data(onemap_example_out)
twopt <- rf_2pts(onemap_example_out)
all_mark <- make_seq(twopt,"all")
groups <- group(all_mark)
(LG1 <- make_seq(groups,1))
(LG.aug<-add_marker(LG1, c(4,7)))

}
\seealso{
\code{\link[onemap]{drop_marker}}
}
