% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dEdq_pois_noinfl.R
\name{dEdq_pois_noinfl}
\alias{dEdq_pois_noinfl}
\title{Compute Partial Derivatives of Expected Values for a Positive Poisson Model}
\usage{
dEdq_pois_noinfl(b, X, dummies, formula)
}
\arguments{
\item{b}{Numeric vector of coefficients for the Poisson model.}

\item{X}{Matrix of predictors for the Poisson model, where rows correspond
to observations and columns to covariates.}

\item{dummies}{Character vector of column names from \code{X} that are treated
as dummy variables for which marginal effects are computed.}
}
\value{
A matrix of partial derivatives (or marginal effects) with rows corresponding to observations
and columns to covariates. Marginal effects for dummy variables are calculated by contrasting
expected values when the dummy is set to 0 versus 1.
}
\description{
This internal function calculates the partial derivatives of expected values
for a positive Poisson regression model with respect to covariates.
It also computes marginal effects for specified dummy variables.
}
\details{
This function:
\itemize{
\item Computes partial derivatives of expected values with respect to covariates in \code{X}.
\item Handles marginal effects for dummy variables by modifying their values in the design matrix
and computing the difference in expected values.
}

It is designed for internal use and assumes correct input structure. Improper inputs may result
in errors or unexpected behavior.
}
\seealso{
\code{\link{E_pois_noinfl}} for computing expected values in the positive Poisson model.
}
\keyword{internal}
