% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rf_plot_functions.R
\name{plot_variable_importance}
\alias{plot_variable_importance}
\title{plot_variable_importance}
\usage{
plot_variable_importance(rf_list, color = "Class", n_metabolites = 10)
}
\arguments{
\item{rf_list}{The output from the random_forest function}

\item{color}{Metabolite metadata to color by}

\item{n_metabolites}{The number of metabolites to include. Metabolites are sorted by decreasing importance.}
}
\description{
Plot the variable importance from a random forest model. Mean Decrease Gini for Classification and
%IncMSE for regression.
}
\examples{
rf_list <- random_forest(c57_nos2KO_mouse_countDF,c57_nos2KO_mouse_metadata,
Treatment ~.,c(60,40),500)
plot_variable_importance(rf_list = rf_list, color = "Class", n_metabolites = 10)
}
