% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KEGG_gather.R
\name{KEGG_gather}
\alias{KEGG_gather}
\alias{KEGG_gather.cpd}
\alias{KEGG_gather.rxn}
\alias{KEGG_gather.KO}
\title{Gather metadata from KEGG for metabolites}
\usage{
KEGG_gather(count_data)

\method{KEGG_gather}{cpd}(count_data)

\method{KEGG_gather}{rxn}(count_data)

\method{KEGG_gather}{KO}(count_data)
}
\arguments{
\item{count_data}{A metabolmics count dataframe with a KEGG identifier columns}
}
\description{
Method for gathering metadata from the KEGG API.
}
\examples{
count_data <- assign_hierarchy(count_data = c57_nos2KO_mouse_countDF,
keep_unknowns = TRUE, identifier = "KEGG")

count_data <- subset(count_data, Subclass_2=="Aldoses")

count_data <- KEGG_gather(count_data = count_data)
}
