% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_volcano.R
\name{plot_volcano}
\alias{plot_volcano}
\title{Create a volcano plot}
\usage{
plot_volcano(count_data, column, size, strpattern, fill, sig_threshold,
  alpha, shape, color)
}
\arguments{
\item{count_data}{The output file from the omu_summary function.}

\item{column}{The column with metadata you want to highlight points in the plot with,
i.e. "Class"}

\item{size}{Size of the points in the plot}

\item{strpattern}{A character vector of levels of the column you want the plot to focus on,
i.e. strpattern = c("Carbohydrates", "Organicacids")}

\item{fill}{A character vector of colors you want your points to be.
Levels of a factor are organzed alphabetically. All levels not in the
strpattern argument will be set to NA.}

\item{sig_threshold}{An integer. Creates a horizontal dashed line for a significance threshold.
i.e. sig_threshold = 0.05. Defaut value is 0.05}

\item{alpha}{A character vector for setting transparency of factor levels.}

\item{shape}{A character vector for setting the shapes for your column levels.
See ggplot2 for an index of shape values.}

\item{color}{A character vector of colors for the column levels. If you choose to use shapes
with outlines, this list will set the outline colors.}
}
\description{
Creates a volcano plot as ggplot2 object using the output of omu_summary
}
\examples{
c57_nos2KO_mouse_countDF <- assign_hierarchy(c57_nos2KO_mouse_countDF, TRUE, "KEGG")
\dontshow{c57_nos2KO_mouse_countDF <- c57_nos2KO_mouse_countDF[1:20,]}
t_test_df <-  omu_summary(count_data = c57_nos2KO_mouse_countDF,
metadata = c57_nos2KO_mouse_metadata, numerator = "Strep", denominator = "Mock",
response_variable = "Metabolite", Factor = "Treatment",
log_transform = TRUE, p_adjust = "BH")

plot_volcano(count_data = t_test_df, column = "Class", strpattern = c("Carbohydrates"),
fill = c("firebrick2", "white"), sig_threshold = 0.05, alpha = c(1,1),
shape = c(1,24), color = c("black", "black"), size = 2)

plot_volcano(count_data = t_test_df, sig_threshold = 0.05, size = 2)
}
