% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mockVocabulary.R
\name{mockVocabularyTables}
\alias{mockVocabularyTables}
\title{It creates a mock database with the vocabulary.}
\usage{
mockVocabularyTables(
  cdm = mockCdmReference(),
  vocabularySet = "mock",
  cdmSource = NULL,
  concept = NULL,
  vocabulary = NULL,
  conceptRelationship = NULL,
  conceptSynonym = NULL,
  conceptAncestor = NULL,
  drugStrength = NULL
)
}
\arguments{
\item{cdm}{name of the cdm object}

\item{vocabularySet}{name of the vocabulary set}

\item{cdmSource}{cdm source table.}

\item{concept}{Concept table.}

\item{vocabulary}{Vocabulary table}

\item{conceptRelationship}{Concept_relationship table.}

\item{conceptSynonym}{Concept_synonym table.}

\item{conceptAncestor}{Concept_ancestor table.}

\item{drugStrength}{Drug_strength table.}
}
\value{
A cdm reference with the vocabulary mock tables
}
\description{
It creates a mock database with the vocabulary.
}
\examples{
library(omock)

cdm <- mockCdmReference() |> mockVocabularyTables(vocabularySet = "mock")

names(cdm)


}
