% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ols-best-subsets-regression.R
\name{ols_step_best_subset}
\alias{ols_step_best_subset}
\alias{ols_best_subset}
\alias{plot.ols_step_best_subset}
\title{Best subsets regression}
\usage{
ols_step_best_subset(model, ...)

\method{plot}{ols_step_best_subset}(x, model = NA, print_plot = TRUE,
  ...)
}
\arguments{
\item{model}{An object of class \code{lm}.}

\item{...}{Other inputs.}

\item{x}{An object of class \code{ols_step_best_subset}.}

\item{print_plot}{logical; if \code{TRUE}, prints the plot else returns a plot object.}
}
\value{
\code{ols_step_best_subset} returns an object of class \code{"ols_step_best_subset"}.
An object of class \code{"ols_step_best_subset"} is a data frame containing the
following components:

\item{n}{model number}
\item{predictors}{predictors in the model}
\item{rsquare}{rsquare of the model}
\item{adjr}{adjusted rsquare of the model}
\item{predrsq}{predicted rsquare of the model}
\item{cp}{mallow's Cp}
\item{aic}{akaike information criteria}
\item{sbic}{sawa bayesian information criteria}
\item{sbc}{schwarz bayes information criteria}
\item{gmsep}{estimated MSE of prediction, assuming multivariate normality}
\item{jp}{final prediction error}
\item{pc}{amemiya prediction criteria}
\item{sp}{hocking's Sp}
}
\description{
Select the subset of predictors that do the best at meeting some
well-defined objective criterion, such as having the largest R2 value or the
smallest MSE, Mallow's Cp or AIC.
}
\section{Deprecated Function}{

\code{ols_best_subset()} has been deprecated. Instead use \code{ols_step_best_subset()}.
}

\examples{
model <- lm(mpg ~ disp + hp + wt + qsec, data = mtcars)
ols_step_best_subset(model)

# plot
model <- lm(mpg ~ disp + hp + wt + qsec, data = mtcars)
k <- ols_step_best_subset(model)
plot(k)

}
\references{
Kutner, MH, Nachtscheim CJ, Neter J and Li W., 2004, Applied Linear Statistical Models (5th edition).
Chicago, IL., McGraw Hill/Irwin.
}
\seealso{
Other variable selection procedures: \code{\link{ols_step_all_possible}},
  \code{\link{ols_step_backward_aic}},
  \code{\link{ols_step_backward_p}},
  \code{\link{ols_step_both_aic}},
  \code{\link{ols_step_forward_aic}},
  \code{\link{ols_step_forward_p}}
}
\concept{variable selection procedures}
