% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ols-stepaic-forward-regression.R
\name{ols_stepaic_forward}
\alias{ols_stepaic_forward}
\alias{ols_stepaic_forward.default}
\alias{plot.ols_stepaic_forward}
\title{Stepwise AIC Forward Regression}
\usage{
ols_stepaic_forward(model, ...)

\method{ols_stepaic_forward}{default}(model, details = FALSE, ...)

\method{plot}{ols_stepaic_forward}(x, ...)
}
\arguments{
\item{model}{an object of class \code{lm}}

\item{...}{other arguments}

\item{details}{logical; if \code{TRUE}, will print the regression result at each step}

\item{x}{an object of class \code{ols_stepaic_forward}}
}
\value{
\code{ols_stepaic_forward} returns an object of class \code{"ols_stepaic_forward"}.
An object of class \code{"ols_stepaic_forward"} is a list containing the
following components:

\item{steps}{total number of steps}
\item{predictors}{variables added to the model}
\item{aics}{akaike information criteria}
\item{ess}{error sum of squares}
\item{rss}{regression sum of squares}
\item{rsq}{rsquare}
\item{arsq}{adjusted rsquare}
}
\description{
Build regression model from a set of candidate predictor variables by entering predictors based on 
Akaike Information Criteria, in a stepwise manner until there is no variable left to enter any more.
}
\examples{
# stepwise forward regression
model <- lm(y ~ ., data = surgical)
ols_stepaic_forward(model)

# stepwise forward regression plot
model <- lm(y ~ ., data = surgical)
k <- ols_stepaic_forward(model)
plot(k)

}
\references{
Venables, W. N. and Ripley, B. D. (2002) Modern Applied Statistics with S. Fourth edition. Springer.
}

