% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ols-all-possible-regression.R
\name{ols_all_subset}
\alias{ols_all_subset}
\alias{plot.ols_all_subset}
\title{All Possible Regression}
\usage{
ols_all_subset(model, ...)

\method{plot}{ols_all_subset}(x, model = NA, ...)
}
\arguments{
\item{model}{an object of class \code{lm}}

\item{...}{other arguments}

\item{x}{an object of class \code{ols_best_subset}}
}
\value{
\code{ols_all_subset} returns an object of class \code{"ols_all_subset"}.
An object of class \code{"ols_all_subset"} is a data frame containing the
following components:

\item{n}{model number}
\item{predictors}{predictors in the model}
\item{rsquare}{rsquare of the model}
\item{adjr}{adjusted rsquare of the model}
\item{predrsq}{predicted rsquare of the model}
\item{cp}{Mallow's Cp}
\item{aic}{Akaike Information Criteria}
\item{sbic}{Sawa Bayesian Information Criteria}
\item{sbc}{Schwarz Bayes Information Criteria}
\item{gmsep}{estimated MSE of prediction, assuming multivariate normality}
\item{jp}{final prediction error}
\item{pc}{Amemiya Prediction Criteria}
\item{sp}{Hocking's Sp}
}
\description{
Fits all regressions involving one regressor, two regressors, three regressors, and so on.
It tests all possible subsets of the set of potential independent variables.
}
\examples{
model <- lm(mpg ~ disp + hp, data = mtcars)
k <- ols_all_subset(model)
k

# plot
plot(k)

}
\references{
Mendenhall William and  Sinsich Terry, 2012, A Second Course in Statistics Regression Analysis (7th edition). 
Prentice Hall
}

