% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pptx_slide_manip.R
\name{add_slide}
\alias{add_slide}
\title{Add a slide}
\usage{
add_slide(
  x,
  layout = "Title and Content",
  master = "Office Theme",
  ...,
  .dots = NULL
)
}
\arguments{
\item{x}{an \code{rpptx} object.}

\item{layout}{slide layout name to use.}

\item{master}{master layout name where \code{layout} is located.}

\item{...}{Key-value pairs of the form \code{"short form location" = object} passed to \link{phs_with}. See section
\code{"Short forms"} in \link{phs_with} for details, available short forms and examples.}

\item{.dots}{List of key-value pairs of the form \code{list("short form location" = object)}. Alternative to \code{...}. See
\link{phs_with} for details.}
}
\description{
Add a slide into a pptx presentation.
}
\examples{
x <- read_pptx()
layout_summary(x)
x <- add_slide(x, layout = "Two Content", master = "Office Theme")

# use `...` to fill placeholders in same step
x <- read_pptx()
x <- add_slide(x,
  layout = "Two Content", `Title 1` = "A title",
  dt = "Jan. 26, 2025", `body[2]` = "Body 2",
  left = "Left side", `6` = "Footer"
)
}
\seealso{
\code{\link[=print.rpptx]{print.rpptx()}}, \code{\link[=read_pptx]{read_pptx()}}, \code{\link[=layout_summary]{layout_summary()}}, \code{\link[=plot_layout_properties]{plot_layout_properties()}}, \code{\link[=ph_with]{ph_with()}}, \code{\link[=phs_with]{phs_with()}}

Other functions to manipulate slides:
\code{\link{move_slide}()},
\code{\link{on_slide}()},
\code{\link{remove_slide}()},
\code{\link{set_notes}()}
}
\concept{slide_manipulation}
