% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppt_ph_with_methods.R
\name{ph_with}
\alias{ph_with}
\alias{ph_with.character}
\alias{ph_with.numeric}
\alias{ph_with.factor}
\alias{ph_with.logical}
\alias{ph_with.block_list}
\alias{ph_with.unordered_list}
\alias{ph_with.data.frame}
\alias{ph_with.gg}
\alias{ph_with.external_img}
\title{add object into a new shape}
\usage{
ph_with(x, value, ...)

\method{ph_with}{character}(x, value, location, ...)

\method{ph_with}{numeric}(x, value, location, format_fun = format, ...)

\method{ph_with}{factor}(x, value, location, ...)

\method{ph_with}{logical}(x, value, location, format_fun = format, ...)

\method{ph_with}{block_list}(x, value, location, ...)

\method{ph_with}{unordered_list}(x, value, location, ...)

\method{ph_with}{data.frame}(x, value, location, header = TRUE,
  first_row = TRUE, first_column = FALSE, last_row = FALSE,
  last_column = FALSE, ...)

\method{ph_with}{gg}(x, value, location, ...)

\method{ph_with}{external_img}(x, value, location, use_loc_size = TRUE,
  ...)
}
\arguments{
\item{x}{a pptx device}

\item{value}{object to add as a new shape.}

\item{...}{Arguments to be passed to methods}

\item{location}{a placeholder location object. This is a convenient
argument that can replace usage of arguments \code{type} and \code{index}.
See section \code{see also}.}

\item{format_fun}{format function for non character vectors}

\item{header}{display header if TRUE}

\item{first_row, last_row, first_column, last_column}{logical for PowerPoint table options}

\item{use_loc_size}{if set to FALSE, external_img width and height will
be used.}
}
\description{
add object into a new shape in a slide.
}
\section{with character}{

When value is a character vector, each value will be
added as a paragraph.
}

\section{with vector}{

When value is a vector, the values will be first formatted and
then add as text, each value will be added as a paragraph.
}

\section{with block_list}{

When value is a block_list object, each value will be
added as a paragraph.
}

\section{with unordered_list}{

When value is a unordered_list object, each value will be
added as a paragraph.
}

\section{with data.frame}{

When value is a data.frame, a simple table
is added, use package \code{flextable} instead
for more advanced formattings.
}

\section{with a ggplot object}{

When value is a ggplot object, a raster plot
is produced and added, use package \code{rvg}
instead for more advanced graphical features.
}

\section{with a external_img object}{

When value is a external_img object, image will be copied
into the PowerPoint presentation. The width and height
specified in call to \code{\link{external_img}} will be
ignored, their values will be those of the location,
unless use_loc_size is set to FALSE.
}

\examples{
library(magrittr)

fileout <- tempfile(fileext = ".pptx")
doc <- read_pptx()
doc <- add_slide(doc, layout = "Two Content",
  master = "Office Theme")
doc <- ph_with(x = doc, value = c("Un titre", "Deux titre"),
               location = ph_location_left() )
doc <- ph_with(x = doc, value = iris[1:4, 3:5],
               location = ph_location_right() )

if( require("ggplot2") ){
  doc <- add_slide(doc, layout = "Title and Content",
    master = "Office Theme")
  gg_plot <- ggplot(data = iris ) +
    geom_point(mapping = aes(Sepal.Length, Petal.Length),
      size = 3) +
    theme_minimal()
  doc <- ph_with(x = doc, value = gg_plot,
                 location = ph_location_fullsize() )
}

doc <- add_slide(doc, layout = "Title and Content",
  master = "Office Theme")
img.file <- file.path( R.home("doc"), "html", "logo.jpg" )
doc <- ph_with(x = doc, external_img(img.file, 100/72, 76/72),
               location = ph_location_right(), use_loc_size = FALSE )

svg_file <- file.path(R.home(component = "doc"), "html/Rlogo.svg")
if( require("rsvg") ){
  doc <- ph_with(x = doc, external_img(svg_file),
    location = ph_location_left(),
    use_loc_size = TRUE )
}



# unordered_list ----
ul <- unordered_list(
  level_list = c(1, 2, 2, 3, 3, 1),
  str_list = c("Level1", "Level2", "Level2", "Level3", "Level3", "Level1"),
  style = fp_text(color = "red", font.size = 0) )
doc <- add_slide(doc, layout = "Title and Content",
                 master = "Office Theme")
doc <- ph_with(x = doc, value = ul,
               location = ph_location_fullsize() )

print(doc, target = fileout )
}
\seealso{
\link{ph_location_type}, \link{ph_location}, \link{ph_location_label},
\link{ph_location_left}, \link{ph_location_right}, \link{ph_location_fullsize}
}
