% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docx_section.R
\name{body_end_block_section}
\alias{body_end_block_section}
\title{add any section}
\usage{
body_end_block_section(x, value)
}
\arguments{
\item{x}{an rdocx object}

\item{value}{a \link{block_section} object}
}
\description{
Add a section to the document. You can
define any section with a \link{block_section} object. All other
\verb{body_end_section_*} are specialized, thiis one is higly flexible
but it's up to the user to define the section properties.
}
\section{Illustrations}{


\if{html}{\figure{body_end_block_section_doc_1.png}{options: width=80\%}}
}

\examples{
library(officer)
str1 <- "Lorem ipsum dolor sit amet, consectetur adipiscing elit."
str1 <- rep(str1, 20)
str1 <- paste(str1, collapse = " ")

ps <- prop_section(
  page_size = page_size(orient = "landscape"),
  page_margins = page_mar(top = 2),
  type = "continuous"
)

doc_1 <- read_docx()
doc_1 <- body_add_par(doc_1, value = str1, style = "Normal")
doc_1 <- body_add_par(doc_1, value = str1, style = "Normal")

doc_1 <- body_end_block_section(doc_1, block_section(ps))

doc_1 <- body_add_par(doc_1, value = str1, style = "centered")

print(doc_1, target = tempfile(fileext = ".docx"))
}
\seealso{
Other functions for Word sections: 
\code{\link{body_end_section_columns_landscape}()},
\code{\link{body_end_section_columns}()},
\code{\link{body_end_section_continuous}()},
\code{\link{body_end_section_landscape}()},
\code{\link{body_end_section_portrait}()}
}
\concept{functions for Word sections}
