% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppt_ph_add.R
\name{ph_add_text}
\alias{ph_add_text}
\title{append text}
\usage{
ph_add_text(x, str, type = NULL, id_chr = NULL, style = fp_text(font.size
  = 0), pos = "after", href = NULL)
}
\arguments{
\item{x}{a pptx device}

\item{str}{text to add}

\item{type}{placeholder type}

\item{id_chr}{placeholder id (a string). This is to be used when a placeholder type
is not unique in the current slide, e.g. two placeholders with type 'body'.
Values can be read from \code{\link{slide_summary}}.}

\item{style}{text style, a \code{\link{fp_text}} object}

\item{pos}{where to add the new element relative to the cursor,
"after" or "before".}

\item{href}{hyperlink}
}
\description{
append text in a placeholder
}
\examples{
library(magrittr)
fileout <- tempfile(fileext = ".pptx")
my_pres <- read_pptx() \%>\%
  add_slide(layout = "Title and Content", master = "Office Theme") \%>\%
  ph_empty(type = "body")

small_red <- fp_text(color = "red", font.size = 14)

my_pres <- my_pres \%>\%
  ph_add_par(level = 3) \%>\%
  ph_add_text(str = "A small red text.", style = small_red) \%>\%
  ph_add_par(level = 2) \%>\%
  ph_add_text(str = "Level 2")

print(my_pres, target = fileout)
}
