% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{logLik.oem}
\alias{logLik.cv.oem}
\alias{logLik.oem}
\alias{logLik.xval.oem}
\title{log likelihood function for fitted oem objects}
\usage{
\method{logLik}{oem}(object, which.model = 1, ...)

\method{logLik}{cv.oem}(object, which.model = 1, ...)

\method{logLik}{xval.oem}(object, which.model = 1, ...)
}
\arguments{
\item{object}{fitted "oem" model object.}

\item{which.model}{If multiple penalties are fit and returned in the same \code{oem} object, the \code{which.model} argument is used to 
specify which model to plot. For example, if the oem object \code{"oemobj"} was fit with argument 
\code{penalty = c("lasso", "grp.lasso")}, then \code{which.model = 2} provides a plot for the group lasso model.}

\item{...}{not used}
}
\description{
log likelihood function for fitted oem objects

log likelihood function for fitted cross validation \code{oem} objects

log likelihood function for fitted cross validation \code{oem} objects
}
\examples{
set.seed(123)
n.obs <- 2000
n.vars <- 50

true.beta <- c(runif(15, -0.25, 0.25), rep(0, n.vars - 15))
x <- matrix(rnorm(n.obs * n.vars), n.obs, n.vars)
y <- rnorm(n.obs, sd = 3) + x \%*\% true.beta

fit <- oem(x = x, y = y, penalty = c("lasso", "mcp"), compute.loss = TRUE)

logLik(fit)

logLik(fit, which.model = "mcp")


fit <- cv.oem(x = x, y = y, penalty = c("lasso", "mcp"), compute.loss = TRUE,
              nlambda = 25)

logLik(fit)

logLik(fit, which.model = "mcp")


fit <- xval.oem(x = x, y = y, penalty = c("lasso", "mcp"), compute.loss = TRUE, 
                nlambda = 25)

logLik(fit)

logLik(fit, which.model = "mcp")

}

