% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix_helpers.R
\name{matrix_indices}
\alias{matrix_indices}
\title{Get \code{matrix} indices}
\usage{
matrix_indices(x, prefix = "", exclude_diagonal = FALSE)
}
\arguments{
\item{x}{A \code{matrix}.}

\item{prefix}{A \code{character} as prefix for the indices.}

\item{exclude_diagonal}{Either \code{TRUE} to exclude indices where row equals column, or
\code{FALSE} to include those.}
}
\value{
A \code{character} \code{vector}.
}
\description{
This function returns \code{matrix} indices as \code{character}.
}
\examples{
M <- diag(3)
matrix_indices(M)
matrix_indices(M, "M_")
matrix_indices(M, "M_", TRUE)

}
