% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_things.R
\name{sample_covariance_matrix}
\alias{sample_covariance_matrix}
\title{Sample covariance matrix}
\usage{
sample_covariance_matrix(dim, df = dim, scale = diag(dim), diag = FALSE)
}
\arguments{
\item{dim}{An \code{integer}, the dimension.}

\item{df}{An \code{integer} greater or equal \code{dim}, the degrees of freedom of
the inverse Wishart distribution.}

\item{scale}{A covariance \code{matrix} of dimension \code{dim}, the scale matrix of the
inverse Wishart distribution.}

\item{diag}{Set to \code{TRUE} for a diagonal matrix.}
}
\value{
A covariance \code{matrix}.
}
\description{
This function samples a covariance matrix from an inverse Wishart
distribution.
}
\examples{
sample_covariance_matrix(dim = 3)

}
