% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_things.R
\name{rwishart}
\alias{rwishart}
\title{Draw from Wishart distribution}
\usage{
rwishart(df, scale, inv = FALSE)
}
\arguments{
\item{df}{An \code{integer}, the degrees of freedom.
Must be greater or equal \code{p}.}

\item{scale}{A \code{matrix}, the scale matrix of dimension \code{p} x \code{p}.
Must be a covariance matrix.}

\item{inv}{A \code{logical}, if \code{TRUE} the density of the Inverse-Wishart
distribution is returned.
By default, \code{inv = FALSE}.}
}
\value{
A \code{matrix}, the random draw.
}
\description{
This function draws from a Wishart or Inverse-Wishart distribution.
}
\examples{
df <- 4
scale <- diag(2)
rwishart(df = df, scale = scale)
rwishart(df = df, scale = scale, inv = TRUE)

}
