% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_resource.R
\name{get_resource}
\alias{get_resource}
\title{Get one or more resources or all resources within a package.}
\usage{
get_resource(package = NULL, resource = NULL, limit = Inf)
}
\arguments{
\item{package}{A character vector specifying package ids or names. If the
\code{resource} argument is not provided all resources under each of the
specified packages will be returned. The \code{package} argument itself is
optional, but one of \code{package} or \code{resource} arguments must be
provided.}

\item{resource}{A character vector specifying resource ids or names. If the
\code{package} argument is also provided then resources will only be
returned if they exist under one of the specified packages, otherwise each
of the specified resources will be returned. The \code{resource} argument
itself is optional, but one of \code{resource} or \code{package} arguments
must be provided.}

\item{limit}{A numeric value specifying the maximum number of rows to be
returned. Default value \code{Inf} returns all rows. Note; when multiple
resources are returned the limit applies to each.}
}
\value{
A list containing all the resources within a package, or those
specified, as data.frames.
}
\description{
Get data from one or more resources, or all resources within a
package, as a list, with each resource in tabular format. Where field
selection and/or filtering of data is required the \code{get_data} function
can be used.
}
\examples{
\dontrun{
get_resource(
  package = "4dd86111-7326-48c4-8763-8cc4aa190c3e",
  limit = 5L
  )
  
get_resource(
  package = "4dd86111-7326-48c4-8763-8cc4aa190c3e",
  resource = "edee9731-daf7-4e0d-b525-e4c1469b8f69",
  limit = 5L
  )

get_resource(
  package = "standard-populations",
  resource = "European Standard Population",
  limit = 5L
  )
  
 get_resource(
  resource = "European Standard Population",
  limit = 5L
  )
}
 
}
