% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export_data.R
\name{export_data}
\alias{export_data}
\title{export_data}
\usage{
export_data(target = "", briefcase = "odkBriefcase_latest", id = "",
  from = "", to = "", filename = paste(id, "_data.csv", sep = ""),
  start = NULL, end = NULL, overwrite = FALSE, exclude = TRUE)
}
\arguments{
\item{target}{Path to directory of ODK Briefcase \code{.jar} file. Directory
path should match directory path used when calling \code{get_briefcase()}.
If ODK Briefcase \code{.jar} file was downloaded manually from \url{https://opendatakit.org},
\code{target} should match the directory path where \code{.jar} file has
been downloaded into.}

\item{briefcase}{Filename of the downloaded ODK Briefcase \code{.jar} file.
Default is \code{odkBriefcase_latest} to match the default filename used
by \code{get_briefcase()}. If ODK Briefcase \code{.jar} file was
downloaded manually from \url{https://opendatakit.org}, filename should
match the default filename used by Open Data Kit which is usually
"ODK Briefcase vX.Y.Z Production.jar" where vX.Y.Z is the version number}

\item{id}{Form ID of form to be pulled}

\item{from}{Path to source ODK Briefcase Storage from which to extract data.
This should match directory path specified when making a call to \code{pull_remote()}
or \code{pull_local()}}

\item{to}{Destination directory to save output data file}

\item{filename}{Filename of output CSV data; default is
\code{paste(id, "_data.csv", sep = "")}}

\item{start}{Include data from submission dates after (inclusive) this start
date in export to CSV; format <yyyy/MM/dd>}

\item{end}{Include data from submission dates before (exclusive) this date in
export to CSV; format <yyyy/MM/dd>}

\item{overwrite}{Overwrite existing output data in destination
directory with the same filename; default is FALSE}

\item{exclude}{Exclude media files on export; default is TRUE}
}
\value{
CSV file in destination directory containing data from the pulled
forms
}
\description{
Export data in CSV format from local ODK Briefcase Storage directory to a
specified destination directory and a specified file name
}
\examples{
# Export data from a specified ODK Briefcase Storage directory to current
# working directory with a filename called "test.csv"
\dontrun{
  dirPath <- tempdir()
  get_briefcase(destination = dirPath)
  export_data(target = dirPath,
              from = dirPath,
              to = dirPath,
              id = "stakeholders",
              filename = "test.csv",
              overwrite = TRUE)
}

}
