% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/toa_api_key.R
\name{register_toa}
\alias{register_toa}
\alias{toa_key}
\alias{has_toa_key}
\alias{check_toa_key}
\title{\strong{Odds API Key Registration}}
\usage{
toa_key()

has_toa_key()

check_toa_key()
}
\value{
Called as a side-effect to ensure that a user has an API key stored in their environment
before making a call to the Odds API service.
}
\description{
Save your API Key as a system environment variable \code{ODDS_API_KEY}
}
\details{
To get access to an API key, follow the instructions at \url{https://the-odds-api.com}\cr
\cr
\strong{Using the key:} \cr
You can save the key for consistent usage by adding \code{ODDS_API_KEY=XXXX-YOUR-API-KEY-HERE-XXXXX} to your .Renviron file (easily accessed via \href{https://usethis.r-lib.org/reference/edit.html}{\strong{\code{usethis::edit_r_environ()}}}). \cr
Run \href{https://usethis.r-lib.org/reference/edit.html}{\strong{\code{usethis::edit_r_environ()}}},
a new script will pop open named \code{.Renviron}, \strong{THEN} \cr
paste the following in the new script that pops up (with\strong{out} quotations)

\if{html}{\out{<div class="sourceCode r">}}\preformatted{ODDS_API_KEY = XXXX-YOUR-API-KEY-HERE-XXXXX
}\if{html}{\out{</div>}}

Save the script and restart your RStudio session, by clicking \code{Session} (in between \code{Plots} and \code{Build}) and click \verb{Restart R} \cr
(there also exists the shortcut \code{Ctrl + Shift + F10} to restart your session).

If set correctly, from then on you should be able to use any of the \code{toa_} functions without any other changes.

\strong{For less consistent usage:} \cr
At the beginning of every session or within an R environment,
save your API key as the environment variable \code{ODDS_API_KEY} (\strong{with} quotations)
using a command like the following.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{Sys.setenv(ODDS_API_KEY = "XXXX-YOUR-API-KEY-HERE-XXXXX")
}\if{html}{\out{</div>}}
}
