% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/g1sst.R
\docType{class}
\name{g1sst-class}
\alias{g1sst-class}
\title{Class to Store G1SST Satellite/Model Data}
\description{
This class stores G1SST model-satellite products.
}
\details{
G1SST is an acronym for global 1-km sea surface temperature, a product
that combines satellite data with the model output. It is provided by
the JPO ROMS (Regional Ocean Modelling System) modelling group.
See the JPL website (reference 1) to learn more about the data, and see
the \code{\link[=read.g1sst]{read.g1sst()}} documentation for an example
of downloading and plotting.

It is important not to regard G1SST data in the same category as,
say, \linkS4class{amsr} data, because the two products
differ greatly with respect to cloud cover. The satellite used by
\linkS4class{amsr} has the ability to sense water temperature
even if there is cloud cover, whereas \code{g1sst} fills in cloud
gaps with model simulations.  It can be helpful to consult
reference 1 for a given time, clicking and then unclicking the radio button
that turns off the model-based filling of cloud gaps.
}
\section{Slots}{

\describe{
\item{\code{data}}{As with all \code{oce} objects, the \code{data} slot
for \code{g1sst} objects is a
\link{list} containing the main data for the object.
{}}

\item{\code{metadata}}{As with all \code{oce} objects, the \code{metadata} slot
for \code{g1sst} objects is a \link{list} containing
information about the \code{data} or about the object itself.
{}}

\item{\code{processingLog}}{As with all \code{oce} objects, the \code{processingLog} slot
for \code{g1sst} objects is a
\link{list} with entries describing the creation and evolution
of the object. The contents are updated by various \code{oce} functions to
keep a record of processing steps.  Object summaries and
\code{\link[=processingLogShow]{processingLogShow()}} both display the log.}
}}

\section{Modifying slot contents}{


Although the \code{[[<-} operator may permit modification of the contents
of \linkS4class{g1sst} objects (see \code{\link{[[<-,g1sst-method}}),
it is better to use \code{\link[=oceSetData]{oceSetData()}} and \code{\link[=oceSetMetadata]{oceSetMetadata()}},
because those functions save an entry in the \code{processingLog}
that describes the change.
}

\section{Retrieving slot contents}{


The full contents of the \code{data} and \code{metadata} slots of a \linkS4class{g1sst}
object may be retrieved in the standard R way using \code{\link[=slot]{slot()}}. For
example \code{slot(o,"data")} returns the \code{data} slot of an object named \code{o},
and similarly \code{slot(o,"metadata")} returns
the \code{metadata} slot.

The slots may also be obtained with the \code{\link{[[,g1sst-method}}
operator, as e.g. \code{o[["data"]]} and \code{o[["metadata"]]}, respectively.

The \code{\link{[[,g1sst-method}} operator can also
be used to retrieve items from within the \code{data} and \code{metadata} slots.
For example, \code{o[["temperature"]]} can be used to retrieve temperature
from an object containing that quantity. The rule is that a named
quantity is sought first within the object's \code{metadata} slot,
with the \code{data} slot being checked only if \code{metadata} does not
contain the item. This \code{[[} method can also be used to get
certain derived quantities, if the object contains sufficient
information to calculate them. For example, an object that holds
(practical) salinity, temperature and pressure, along with
longitude and latitude, has sufficient information to compute
Absolute Salinity, and so \code{o[["SA"]]} will yield the
calculated Absolute Salinity.

It is also possible to find items more directly, using \code{\link[=oceGetData]{oceGetData()}} and
\code{\link[=oceGetMetadata]{oceGetMetadata()}}, but neither of these functions can
retrieve derived items.
}

\references{
\enumerate{
\item JPO OurOcean Portal \verb{https://ourocean.jpl.nasa.gov/SST/}
(link worked in 2016 but was seen to fail 2017 Feb 2).
}
}
\seealso{
Other classes holding satellite data: 
\code{\link{amsr-class}},
\code{\link{landsat-class}},
\code{\link{satellite-class}}

Other things related to g1sst data: 
\code{\link{[[,g1sst-method}},
\code{\link{[[<-,g1sst-method}},
\code{\link{read.g1sst}()}
}
\author{
Dan Kelley
}
\concept{classes holding satellite data}
\concept{things related to g1sst data}
