% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{errorbars}
\alias{errorbars}
\title{Draw Error Bars on an Existing xy Diagram}
\usage{
errorbars(x, y, xe, ye, percent = FALSE, style = 0, length = 0.025, ...)
}
\arguments{
\item{x, y}{coordinates of points on the existing plot.}

\item{xe, ye}{errors on x and y coordinates of points on the existing plot,
each either a single number or a vector of length identical to that of
the corresponding coordinate.}

\item{percent}{boolean flag indicating whether \code{xe} and \code{ye} are
in terms of percent of the corresponding \code{x} and \code{y} values.}

\item{style}{indication of the style of error bar.  Using \code{style=0}
yields simple line segments (drawn with \code{\link[=segments]{segments()}}) and
\code{style=1} yields line segments with short perpendicular endcaps.}

\item{length}{length of endcaps, for \code{style=1} only; it is passed to
\code{\link[=arrows]{arrows()}}, which is used to draw that style of error bars.}

\item{\dots}{graphical parameters passed to the code that produces the error
bars, e.g. to \code{\link[=segments]{segments()}} for \code{style=0}.}
}
\description{
Draw Error Bars on an Existing xy Diagram
}
\examples{
library(oce)
data(ctd)
S <- ctd[["salinity"]]
T <- ctd[["temperature"]]
plot(S, T)
errorbars(S, T, 0.05, 0.5)
}
\author{
Dan Kelley
}
