% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{labelWithUnit}
\alias{labelWithUnit}
\title{Create label with unit}
\usage{
labelWithUnit(name, unit = NULL)
}
\arguments{
\item{name}{character value naming a quantity.}

\item{unit}{a list containing items \code{unit} and (optionally) \code{scale}, only the
first of which, an \code{\link[=expression]{expression()}}, is used.  If \code{unit} is not provided,
then a default will be used (see \dQuote{Details}).}
}
\value{
\code{labelWithUnit} returns a language object, created with \code{\link[=bquote]{bquote()}},
that that may supplied as a text string to \code{\link[=legend]{legend()}}, \code{\link[=mtext]{mtext()}}, \code{\link[=text]{text()}},
etc.
}
\description{
\code{labelWithUnit} creates a label with a unit, for graphical
display, e.g. by \code{\link{plot,section-method}}.
The unit is enclosed in square brackets, although setting
\code{options(oceUnitBracket="(")} will cause parentheses to be
used, instead.
}
\details{
If \code{name} is in a standard list, then alterations are made as appropriate,
e.g. \code{"SA"} or \code{"Absolute Salinity"} yields an S with subscript A; \code{"CT"} or
\code{"Conservative Temperature"} yields an upper-case Theta, \code{sigmaTheta}
yields a sigma with subscript theta, \code{sigma0} yields
sigma with subscript 0 (with similar for 1 through 4), \code{"N2"} yields "N" with
superscript 2, and \code{"pressure"} yields "p".
These basic hydrographic quantities have default units that will
be used if \code{unit} is not supplied (see \dQuote{Examples}).

In addition to the above, several chemical names are recognized,
but no unit is guessed for them, because the oceanographic
community lacks agreed-upon standards.

If \code{name} is not recognized, then it is simply repeated in the
return value.
}
\examples{
library(oce)
# 1. temperature has a predefined unit, but this can be overruled
labelWithUnit("temperature")
labelWithUnit("temperature",
    list(unit=expression(m/s), scale="erroneous"))
# 2. phosphate lacks a predefined unit
labelWithUnit("phosphate")
data(section)
labelWithUnit("phosphate",
    section[["station",1]][["phosphateUnit"]])

}
\seealso{
Other functions that create labels: 
\code{\link{resizableLabel}()}
}
\author{
Dan Kelley
}
\concept{functions that create labels}
